
///////////////////////////////////////////////////////////////////////////////////////////////////////////

// Caching.
//	VMF Caching decreases load times by caching the already parsed vmf and preview
//	instead of reloading it each time, the downside however is that changes to vmfs after the
//	first load won't take effect until caching is disabled or the map restarted.
VMFSuite.Config[ 'cache' ]		= true;


// Force delay spawning.
//	Delay spawning decreases the lockup felt when loading a vmf by loading the vmf entity by entity
//	across multiple game frames.
VMFSuite.Config['force_delay_spawn']	= true;


// Multi-Spawn
//	Multi-Spawn allows you to spawn the same vmf several times, without reloading it
//	from file.
VMFSuite.Config['multispawn']		= true;


// VMF Pre-parse
//	When the server starts, this parses all vmfs that reside in vmf/server.
//	This can improve loadtimes quite a bit.  But it comes at a cost of a slightly longer
//	server startup time.
//
//	This will also however give you vmf information when you hover your mouse over a vmf int he spawn
//	menu.
//VMFSuite.Config['preparse']		= true;




// Database Type.
//	By default VMF-Suite uses the built in SQLite database to store various vmf related things.
//	You can however change over to a MySQL database to replicate these settings among multiple servers.
VMFSuite.Config['database_type']	= "SQLite";		// SQLite, MySQL

// Database Username
//	This should be ignored unless you have database type set to MySQL.
VMFSuite.Config['database_user']	= "";

// Database Passowrd
//	This should be ignored unless you have database type set to MySQL.
VMFSuite.Config['database_password']	= "";

// Database Database
//	This should be ignored unless you have database type set to MySQL.
VMFSuite.Config['database_database']	= "";


///////////////////////////////////////////////////////////////////////////////////////////////////////////


// Don't replicate these to the client
local DontReplicate = {
	"database_type",
	"database_user",
	"database_password",
	"database_database",
	
};


// create a new config sender class.
local CConfigSender	= OOP_Derive( CHook );

// constructor
function CConfigSender:__ctor( )
	// hook.
	self:HookEvent( "PlayerInitialSpawn" );

end

// Player spawned
function CConfigSender:OnPlayerInitialSpawn( pl )
	// send the configuration to the client.
	local key, value;
	for key, value in pairs( VMFSuite.Config ) do
		// should we send it?
		if( !table.HasValue( DontReplicate, key ) ) then
			// send
			umsg.Start( "CloneConfig", pl );
				umsg.String( key );
				umsg.String( type( value ) );
				umsg.String( tostring( value ) );
			umsg.End();
		
		end
	
	end
	
end

// create
local configsender = CConfigSender:create();
